/*****************************************************************
 * cmm_wrapapi.h
 *
 * Copyright (C) 2005 Canon Inc.
 * All rights reserved.  Company confidential.
 *****************************************************************
 */

#ifndef	_CMM_WRAPAPI_H
#define _CMM_WRAPAPI_H

#include <sys/types.h>

#ifdef __cplusplus
extern "C" {
#endif	/* __cplusplus */


/*------------------------------------------------
 * Type/Constant definition
 *------------------------------------------------*/

/*--- Type definition ---*/
typedef	int				CABool;

#ifndef __CABYTE_
#define	__CABYTE_
typedef	unsigned char	CAByte;
#endif

typedef	void			CACGObj;
typedef	void			CACTObj;
typedef	void			CAHTObj;
typedef	void			CATNLObj;
typedef void			CAHSObj;

#define	CABOOL_TRUE			1		/* True */
#define	CABOOL_FALSE		0		/* False */

/*--- PDL id. definition ---*/
#define	CAPDL_LIPS		0x0000		/* LIPS IV */
#define	CAPDL_CARPS		0x00C0		/* CARPS */
#define	CAPDL_PCL5c		0x0110		/* PCL 5c */
#define	CAPDL_UFR		0x7000		/* UFR */
#define	CAPDL_CAPT		0xC000		/* CAPT */
#define	CAPDL_BDL		0x6000		/* BDL */
#define	CAPDL_NCAP		0xD000		/* NCAP */

/*--- CMS ---*/
// Color Mode
#define	CACMS_COLOR			2		/* Color mode */
#define	CACMS_MONO			1		/* Monochrome mode */

// Color Correction Mode
#define	CACMS_MODE_MATCH	1		/* color matching */
#define	CACMS_MODE_GAMMA	0		/* gamma correction */

// Matching Method
#define	CACMS_MATCH_PERCEPTUAL				0		/* perceptual */
#define	CACMS_MATCH_COLORIMETRIC			1		/* colorimetric */
#define	CACMS_MATCH_SATURATION				2		/* saturation */
#define	CACMS_MATCH_ABSOLUTECOLORIMETRIC	3		/* absolutecolorimetric */
#define	CACMS_MATCH_PHOTOGRAPHICS			4		/* photographics */
#define CACMS_MATCH_VIVID					5		/* Vivid Color */

// Gamma Value
#define	CACMS_GAMMA_10		0		/* gamma = 1.0 */
#define	CACMS_GAMMA_14		1		/*         1.4 */
#define	CACMS_GAMMA_18		2		/*         1.8 */
#define	CACMS_GAMMA_22		3		/*         2.2 */

// Source Profile id.
#define	CACMS_DEV_SRGB		0		/* sRGB v1.20 */
#define	CACMS_DEV_HDTV_G15	1		/* CANON HDTV gamma 1.5 monitor */
#define	CACMS_DEV_HDTV_G18	2		/* CANON HDTV gamma 1.8 monitor */
#define	CACMS_DEV_HDTV_G21	3		/* CANON HDTV gamma 2.1 monitor */
#define	CACMS_DEV_HDTV_G24	4		/* CANON HDTV gamma 2.4 monitor */
#define CACMS_DEV_SRGB_131	5		/* sRGB v1.31 (CANON) */
#define CACMS_DEV_SRGB_300	6		/* sRGB v3.0 (CANON) */
	
// Output Color
#define	CACMS_RGB			0		/* RGB data */
#define	CACMS_GRAY			1		/* Gray data */

// Object Type value 
#define	CACMS_OBJ_TEXT		0		/* Text object */
#define	CACMS_OBJ_GRAPHICS	1		/* Graphics */
#define	CACMS_OBJ_IMAGE		2		/* Image */
/* added '05.10.05 */
#define	CACMS_OBJ_LINE		0x8201	/* Line */
#define	CACMS_OBJ_THINLINE	0x8101	/* Thin Line */
#define	CACMS_OBJ_SMALLTEXT	0x8100	/* Small Text */

// Color Order (added '05.10.05)
#define	CACMS_ORDER_RGB		0		/* RGBRGB...-> RGBRGB... */
#define	CACMS_ORDER_BGR		1		/* BGRBGR...->BGRBGR... */
#define	CACMS_ORDER_BGR0	2		/* BGR0BGR0...-> BGR0BGR0...*/
#define	CACMS_ORDER_RGBg	3		/* RGBRGB...->gg... */
#define	CACMS_ORDER_BGRg	4		/* BGRBGR...->gg... */
#define	CACMS_ORDER_BGR0g	5		/* BGR0BGR0...->gg... */

/* Addtional Param ID */
#define	CACMS_ADDPARAMID_NONE				0
#define CACMS_ADDPARAMID_PROFILEHANDLING	1
#define CACMS_ADDPARAMID_TRUTHCMS			2
#define CACMS_ADDPARAMID_GRAYCONV			3

/*_ CMS_ADDPARAM INDEX */
#define CACMS_ADDPARAM_INDEX_PROFILEHANDLING	0				/*_ プロファイルハンドリング用ID */
#define CACMS_ADDPARAM_INDEX_TRUTHCMS			1				/*_ 真CMS用ID */
#define CACMS_ADDPARAM_INDEX_GRAYCONVINFO		2				/*_ モノクロ変換切り替え用ID */

/*--- CT ---*/
// Calibration Data Version id.
#define	CACT_CALIB_V1		0		/* for LBP-2160/2260, LBP-2040 */
#define	CACT_CALIB_V2		1		/* LBP-2360 and later */
#define	CACT_CALIB_V3		2		/* E313 and later */
#define	CACT_CALIB_V4		3		/* UserCaliblation */
#define CACT_CALIB_V4PLUS	4		/* CalibV4 plus AddtionalParam */

// Mode id.
#define	CACT_MODE_MONO		0		/* Monochrome */
#define	CACT_MODE_COLOR		1		/* Color */
#define	CACT_MODE_GROSS		0x0002	/* HiGross */
#define CACT_MODE_OHP		0x0004	/* OHP */
#define CACT_MODE_HAGAKI	0x0008	/* Kousoku Hagaki */
#define CACT_MODE_OHP2		0x0010	/* OHP mode2(Reflect) */
#define	CACT_MODE_HQ		0x0080	/* High-Quality (added '06.06.13) */
#define CACT_MODE_TONERSAVE	0x0020	/* TonerSave */
#define	CACT_MODE_BARCODE	0x0100	/* BarCode Mode */
#define	CACT_MODE_WHITEGAP	0x0200	/* WhiteGap Mode*/

// Page orientation code
#define CACT_PORTRAIT	0			/* Portrait */
#define CACT_LANDSCAPE	1			/* Landscape */

// Color Order (added '05.10.06)
#define	CACT_ORDER_RGB		0		/* RGBRGB... */
#define	CACT_ORDER_BGR		2		/* BGRBGR... */
#define	CACT_ORDER_BGR0		1		/* BGR0BGR0... */

// Paper size code (conform to WinGdi.h)
#define CACT_PAPER_LETTER               1  /* Letter 8 1/2 x 11 in               */
#define CACT_PAPER_LETTERSMALL          2  /* Letter Small 8 1/2 x 11 in         */
#define CACT_PAPER_TABLOID              3  /* Tabloid 11 x 17 in                 */
#define CACT_PAPER_LEDGER               4  /* Ledger 17 x 11 in                  */
#define CACT_PAPER_LEGAL                5  /* Legal 8 1/2 x 14 in                */
#define CACT_PAPER_STATEMENT            6  /* Statement 5 1/2 x 8 1/2 in         */
#define CACT_PAPER_EXECUTIVE            7  /* Executive 7 1/4 x 10 1/2 in        */
#define CACT_PAPER_A3                   8  /* A3 297 x 420 mm                    */
#define CACT_PAPER_A4                   9  /* A4 210 x 297 mm                    */
#define CACT_PAPER_A4SMALL             10  /* A4 Small 210 x 297 mm              */
#define CACT_PAPER_A5                  11  /* A5 148 x 210 mm                    */
#define CACT_PAPER_B4                  12  /* B4 (JIS) 250 x 354                 */
#define CACT_PAPER_B5                  13  /* B5 (JIS) 182 x 257 mm              */
#define CACT_PAPER_FOLIO               14  /* Folio 8 1/2 x 13 in                */
#define CACT_PAPER_QUARTO              15  /* Quarto 215 x 275 mm                */
#define CACT_PAPER_10X14               16  /* 10x14 in                           */
#define CACT_PAPER_11X17               17  /* 11x17 in                           */
#define CACT_PAPER_NOTE                18  /* Note 8 1/2 x 11 in                 */
#define CACT_PAPER_ENV_9               19  /* Envelope #9 3 7/8 x 8 7/8          */
#define CACT_PAPER_ENV_10              20  /* Envelope #10 4 1/8 x 9 1/2 (COM10) */
#define CACT_PAPER_ENV_11              21  /* Envelope #11 4 1/2 x 10 3/8        */
#define CACT_PAPER_ENV_12              22  /* Envelope #12 4 \276 x 11           */
#define CACT_PAPER_ENV_14              23  /* Envelope #14 5 x 11 1/2            */
#define CACT_PAPER_CSHEET              24  /* C size sheet                       */
#define CACT_PAPER_DSHEET              25  /* D size sheet                       */
#define CACT_PAPER_ESHEET              26  /* E size sheet                       */
#define CACT_PAPER_ENV_DL              27  /* Envelope DL 110 x 220mm            */
#define CACT_PAPER_ENV_C5              28  /* Envelope C5 162 x 229 mm           */
#define CACT_PAPER_ENV_C3              29  /* Envelope C3  324 x 458 mm          */
#define CACT_PAPER_ENV_C4              30  /* Envelope C4  229 x 324 mm          */
#define CACT_PAPER_ENV_C6              31  /* Envelope C6  114 x 162 mm          */
#define CACT_PAPER_ENV_C65             32  /* Envelope C65 114 x 229 mm          */
#define CACT_PAPER_ENV_B4              33  /* Envelope B4  250 x 353 mm          */
#define CACT_PAPER_ENV_B5              34  /* Envelope B5  176 x 250 mm          */
#define CACT_PAPER_ENV_B6              35  /* Envelope B6  176 x 125 mm          */
#define CACT_PAPER_ENV_ITALY           36  /* Envelope 110 x 230 mm              */
#define CACT_PAPER_ENV_MONARCH         37  /* Envelope Monarch 3.875 x 7.5 in    */
#define CACT_PAPER_ENV_PERSONAL        38  /* 6 3/4 Envelope 3 5/8 x 6 1/2 in    */
#define CACT_PAPER_FANFOLD_US          39  /* US Std Fanfold 14 7/8 x 11 in      */
#define CACT_PAPER_FANFOLD_STD_GERMAN  40  /* German Std Fanfold 8 1/2 x 12 in   */
#define CACT_PAPER_FANFOLD_LGL_GERMAN  41  /* German Legal Fanfold 8 1/2 x 13 in */

#define CACT_PAPER_ISO_B4              42  /* B4 (ISO) 250 x 353 mm              */
#define CACT_PAPER_JAPANESE_POSTCARD   43  /* Japanese Postcard 100 x 148 mm     */
#define CACT_PAPER_9X11                44  /* 9 x 11 in                          */
#define CACT_PAPER_10X11               45  /* 10 x 11 in                         */
#define CACT_PAPER_15X11               46  /* 15 x 11 in                         */
#define CACT_PAPER_ENV_INVITE          47  /* Envelope Invite 220 x 220 mm       */
#define CACT_PAPER_RESERVED_48         48  /* RESERVED--DO NOT USE               */
#define CACT_PAPER_RESERVED_49         49  /* RESERVED--DO NOT USE               */
#define CACT_PAPER_LETTER_EXTRA        50  /* Letter Extra 9 \275 x 12 in        */
#define CACT_PAPER_LEGAL_EXTRA         51  /* Legal Extra 9 \275 x 15 in         */
#define CACT_PAPER_TABLOID_EXTRA       52  /* Tabloid Extra 11.69 x 18 in        */
#define CACT_PAPER_A4_EXTRA            53  /* A4 Extra 9.27 x 12.69 in           */
#define CACT_PAPER_LETTER_TRANSVERSE   54  /* Letter Transverse 8 \275 x 11 in   */
#define CACT_PAPER_A4_TRANSVERSE       55  /* A4 Transverse 210 x 297 mm         */
#define CACT_PAPER_LETTER_EXTRA_TRANSVERSE 56 /* Letter Extra Transverse 9\275 x 12 in */
#define CACT_PAPER_A_PLUS              57  /* SuperA/SuperA/A4 227 x 356 mm      */
#define CACT_PAPER_B_PLUS              58  /* SuperB/SuperB/A3 305 x 487 mm      */
#define CACT_PAPER_LETTER_PLUS         59  /* Letter Plus 8.5 x 12.69 in         */
#define CACT_PAPER_A4_PLUS             60  /* A4 Plus 210 x 330 mm               */
#define CACT_PAPER_A5_TRANSVERSE       61  /* A5 Transverse 148 x 210 mm         */
#define CACT_PAPER_B5_TRANSVERSE       62  /* B5 (JIS) Transverse 182 x 257 mm   */
#define CACT_PAPER_A3_EXTRA            63  /* A3 Extra 322 x 445 mm              */
#define CACT_PAPER_A5_EXTRA            64  /* A5 Extra 174 x 235 mm              */
#define CACT_PAPER_B5_EXTRA            65  /* B5 (ISO) Extra 201 x 276 mm        */
#define CACT_PAPER_A2                  66  /* A2 420 x 594 mm                    */
#define CACT_PAPER_A3_TRANSVERSE       67  /* A3 Transverse 297 x 420 mm         */
#define CACT_PAPER_A3_EXTRA_TRANSVERSE 68  /* A3 Extra Transverse 322 x 445 mm   */

#define CACT_PAPER_DBL_JAPANESE_POSTCARD 69 /* Japanese Double Postcard 200 x 148 mm */
#define CACT_PAPER_A6                  70  /* A6 105 x 148 mm                 */
#define CACT_PAPER_JENV_KAKU2          71  /* Japanese Envelope Kaku #2       */
#define CACT_PAPER_JENV_KAKU3          72  /* Japanese Envelope Kaku #3       */
#define CACT_PAPER_JENV_CHOU3          73  /* Japanese Envelope Chou #3       */
#define CACT_PAPER_JENV_CHOU4          74  /* Japanese Envelope Chou #4       */
#define CACT_PAPER_LETTER_ROTATED      75  /* Letter Rotated 11 x 8 1/2 11 in */
#define CACT_PAPER_A3_ROTATED          76  /* A3 Rotated 420 x 297 mm         */
#define CACT_PAPER_A4_ROTATED          77  /* A4 Rotated 297 x 210 mm         */
#define CACT_PAPER_A5_ROTATED          78  /* A5 Rotated 210 x 148 mm         */
#define CACT_PAPER_B4_JIS_ROTATED      79  /* B4 (JIS) Rotated 364 x 257 mm   */
#define CACT_PAPER_B5_JIS_ROTATED      80  /* B5 (JIS) Rotated 257 x 182 mm   */
#define CACT_PAPER_JAPANESE_POSTCARD_ROTATED 81 /* Japanese Postcard Rotated 148 x 100 mm */
#define CACT_PAPER_DBL_JAPANESE_POSTCARD_ROTATED 82 /* Double Japanese Postcard Rotated 148 x 200 mm */
#define CACT_PAPER_A6_ROTATED          83  /* A6 Rotated 148 x 105 mm         */
#define CACT_PAPER_JENV_KAKU2_ROTATED  84  /* Japanese Envelope Kaku #2 Rotated */
#define CACT_PAPER_JENV_KAKU3_ROTATED  85  /* Japanese Envelope Kaku #3 Rotated */
#define CACT_PAPER_JENV_CHOU3_ROTATED  86  /* Japanese Envelope Chou #3 Rotated */
#define CACT_PAPER_JENV_CHOU4_ROTATED  87  /* Japanese Envelope Chou #4 Rotated */
#define CACT_PAPER_B6_JIS              88  /* B6 (JIS) 128 x 182 mm           */
#define CACT_PAPER_B6_JIS_ROTATED      89  /* B6 (JIS) Rotated 182 x 128 mm   */
#define CACT_PAPER_12X11               90  /* 12 x 11 in                      */
#define CACT_PAPER_JENV_YOU4           91  /* Japanese Envelope You #4        */
#define CACT_PAPER_JENV_YOU4_ROTATED   92  /* Japanese Envelope You #4 Rotated*/
#define CACT_PAPER_P16K                93  /* PRC 16K 146 x 215 mm            */
#define CACT_PAPER_P32K                94  /* PRC 32K 97 x 151 mm             */
#define CACT_PAPER_P32KBIG             95  /* PRC 32K(Big) 97 x 151 mm        */
#define CACT_PAPER_PENV_1              96  /* PRC Envelope #1 102 x 165 mm    */
#define CACT_PAPER_PENV_2              97  /* PRC Envelope #2 102 x 176 mm    */
#define CACT_PAPER_PENV_3              98  /* PRC Envelope #3 125 x 176 mm    */
#define CACT_PAPER_PENV_4              99  /* PRC Envelope #4 110 x 208 mm    */
#define CACT_PAPER_PENV_5              100 /* PRC Envelope #5 110 x 220 mm    */
#define CACT_PAPER_PENV_6              101 /* PRC Envelope #6 120 x 230 mm    */
#define CACT_PAPER_PENV_7              102 /* PRC Envelope #7 160 x 230 mm    */
#define CACT_PAPER_PENV_8              103 /* PRC Envelope #8 120 x 309 mm    */
#define CACT_PAPER_PENV_9              104 /* PRC Envelope #9 229 x 324 mm    */
#define CACT_PAPER_PENV_10             105 /* PRC Envelope #10 324 x 458 mm   */
#define CACT_PAPER_P16K_ROTATED        106 /* PRC 16K Rotated                 */
#define CACT_PAPER_P32K_ROTATED        107 /* PRC 32K Rotated                 */
#define CACT_PAPER_P32KBIG_ROTATED     108 /* PRC 32K(Big) Rotated            */
#define CACT_PAPER_PENV_1_ROTATED      109 /* PRC Envelope #1 Rotated 165 x 102 mm */
#define CACT_PAPER_PENV_2_ROTATED      110 /* PRC Envelope #2 Rotated 176 x 102 mm */
#define CACT_PAPER_PENV_3_ROTATED      111 /* PRC Envelope #3 Rotated 176 x 125 mm */
#define CACT_PAPER_PENV_4_ROTATED      112 /* PRC Envelope #4 Rotated 208 x 110 mm */
#define CACT_PAPER_PENV_5_ROTATED      113 /* PRC Envelope #5 Rotated 220 x 110 mm */
#define CACT_PAPER_PENV_6_ROTATED      114 /* PRC Envelope #6 Rotated 230 x 120 mm */
#define CACT_PAPER_PENV_7_ROTATED      115 /* PRC Envelope #7 Rotated 230 x 160 mm */
#define CACT_PAPER_PENV_8_ROTATED      116 /* PRC Envelope #8 Rotated 309 x 120 mm */
#define CACT_PAPER_PENV_9_ROTATED      117 /* PRC Envelope #9 Rotated 324 x 229 mm */
#define CACT_PAPER_PENV_10_ROTATED     118 /* PRC Envelope #10 Rotated 458 x 324 mm */

#define CACT_PAPER_USER                256	/* User Define Size */

#define	CACT_PAPER_JAPANESE_ENV_Y2		262	/* Japanese Envelope You #2 114 x 162 mm */
#define	CACT_PAPER_FOUR_JAPANESE_POSTCARD	4300	/* Japanese Quad Postcard 200 x 296 mm */
#define	CACT_PAPER_SRA3					4318	/* SRA3 320 x 450 mm */
#define	CACT_PAPER_13X19				4323	/* 13x19" */
#define	CACT_PAPER_GBT_8K				4327	/* 8K 270 x 390 mm */
#define	CACT_PAPER_GBT_16K				4328	/* 16K 196 x 270 mm */
#define	CACT_PAPER_ARCH_B				4446	/* 12x18" */
#define	CACT_PAPER_INDEX_3X5			4600	/* Index Card 3 x 5" */
#define CACT_PAPER_JENV_CHOU40         	4618	/* Japanese Envelope Chou #40 */
#define CACT_PAPER_LONG_SHEET_297X900   4666	/* Long Sheet (297 mm x 900 mm) */
#define CACT_PAPER_LONG_SHEET_297X1200  4667	/* Long Sheet (297 mm x 1200 mm) */

/*--- HT ---*/
// Dither id.
#define	CAHT_DITHER_KAICHO		0x0000		/* Kaicho */
#define	CAHT_DITHER_KAIZODO		0x0001		/* Kaizoudo */
#define	CAHT_DITHER_KOUKAIZODO 	0x0008		/* Koukaizodo */
#define	CAHT_DITHER_TONE		0x0200		/* Tone */
#define CAHT_DITHER_NONE		0x4000		/* No Dither ('06.04.26) */
#define	CAHT_DITHER_ED			0x1000		/* Error Diffusion ('07.03.06) */
#define	CAHT_DITHER_TBIC		0x2000		/* TBIC ('07.04.24) */

#define	CAHT_DITHER_1BIT		0x0000		/* 1bit */
#define	CAHT_DITHER_2BIT		0x0080		/* 2bit */
#define	CAHT_DITHER_4BIT		0x0010		/* 4bit */

#define	CAHT_DITHER_MONOLOW		0x0000		/* Monochrome 300dpi */
#define	CAHT_DITHER_MONOHIGH	0x0002		/*            600dpi */
#define	CAHT_DITHER_MONOSUPER	0x0004		/*            1200dpi */
#define CAHT_DITHER_600X400DPI	0x0020		/* Mono 600x400dpi ('07.09.05) */
#define	CAHT_DITHER_COLORSUPER	0x0004		/* Color 1200dpi */

#define CAHT_DITHER_NOROTATE	0x8000		/* Dither rotation control flag */
	
// Object color
#define	CAHT_COLOR_K		0
#define	CAHT_COLOR_Y		1
#define	CAHT_COLOR_M		2
#define	CAHT_COLOR_C		3
#define	CAHT_MONO			0

/*--- TNL ---*/
// Target
#define	CATNL_PRINTER		0		/* Printer */
#define	CATNL_DISPLAY		1		/* Display */


/*------------------------------------------------
 *  Structure declaration
 *------------------------------------------------*/

// Color Correction Info. for each Object
typedef struct {
	CAByte	bCorrectionMode;		/* printer name string */
	CAByte	bMatchingMethod;		/* color mode */
	CAByte	bGammaValue;			/* gamma value */
	int		nSourceProfile;			/* source profile id. */
} CAObjCmsParam;

// LUT Information structure 
typedef struct {
	long	Text;
	long	Graphics;
	long	Image;
} CALUTInfo;

// CACalib structure
typedef struct {
	char	*pY;
	char	*pM;
	char	*pC;
	char	*pK;
} CACalib;

// CACalib2 structure
typedef struct {
	char	*pDhalf_Y_SoftCalib;
	char	*pDhalf_M_SoftCalib;
	char	*pDhalf_C_SoftCalib;
	char	*pDhalf_K_SoftCalib;
	char	*pCalibTable_SoftCalib;
	char	*pDhalf_Y_Current;
	char	*pDhalf_M_Current;
	char	*pDhalf_C_Current;
	char	*pDhalf_K_Current;
} CACalib2;

// CACalib3 structure
typedef struct {
	void			*pDhalf_Y_Current;
	void			*pDhalf_M_Current;
	void			*pDhalf_C_Current;
	void			*pDhalf_K_Current;
	void			*pARCDATlite_Y;
	void			*pARCDATlite_M;
	void			*pARCDATlite_C;
	void			*pARCDATlite_K;
	void			*pDhalf_Y_SoftCalib;
	void			*pDhalf_M_SoftCalib;
	void			*pDhalf_C_SoftCalib;
	void			*pDhalf_K_SoftCalib;
	void			*pCalibTable_SoftCalib_0;
	void			*pCalibTable_SoftCalib_1;
	unsigned long	dwCoverage_Y;
	unsigned long	dwCoverage_M;
	unsigned long	dwCoverage_C;
	unsigned long	dwCoverage_K;
	char			chFvalue_Y;
	char			chFvalue_M;
	char			chFvalue_C;
	char			chFvalue_K;
} CACalib3;
	
// CACalib4 structure
typedef struct {
	void			*pDhalf_Y_Current;
	void			*pDhalf_M_Current;
	void			*pDhalf_C_Current;
	void			*pDhalf_K_Current;
	void			*pARCDATlite_Y;
	void			*pARCDATlite_M;
	void			*pARCDATlite_C;
	void			*pARCDATlite_K;
	void			*pDhalf_Y_SoftCalib;
	void			*pDhalf_M_SoftCalib;
	void			*pDhalf_C_SoftCalib;
	void			*pDhalf_K_SoftCalib;
	void			*pCalibTable_SoftCalib_0;
	void			*pCalibTable_SoftCalib_1;
	unsigned long	dwCoverage_Y;
	unsigned long	dwCoverage_M;
	unsigned long	dwCoverage_C;
	unsigned long	dwCoverage_K;
	char			chFvalue_Y;
	char			chFvalue_M;
	char			chFvalue_C;
	char			chFvalue_K;
	void			*pUserCalibInfo;
} CACalib4;

typedef struct {
    unsigned long   dwTargetDensityType;
    unsigned long   dwObjectID;
    unsigned long   dwMediaType;
    void            *pCalibrationTable;
} CACalibTable;

typedef struct{
    unsigned long   dwCalibrationTableNum;
    unsigned long   dwInputCalibrationDepth;
    unsigned long   dwOutputCalibrationDepth;
    CACalibTable    *pUserCalibTable;
} CACalibInfo;
    
#define kADDITIONALPARAM_ID_TONERTUNE 0
typedef struct{
    unsigned long dwID;
    char chTonerTune[3][4];
} CATonerTuneParam;

#define kADDITIONALPARAM_ID_TONERSAVE 1
typedef struct{
    unsigned long dwID;
    char chTonerSavePattern;
} CATonerSaveParam;
    
#define kADDITIONALPARAM_MAX 5
typedef struct{
	short	paramID;
    void*	pParam;
} CAAddParam;

typedef struct{
    void *pParam[kADDITIONALPARAM_MAX];
} CAAdditionalParam;

// CACalib4Plus structure
typedef struct {
	void			*pCACalib4;
	void			*pAddtionalParam;
} CACalib4Plus;


// Dither Matrix structure
typedef struct {
	unsigned long	dwVersion;
	unsigned long	dwSize;
	unsigned long	dwPlaneCount;
	unsigned long	dwEnumType;
} CAMatrixInfoHeader;

typedef struct {
	unsigned long	dwSize;				/* size of this structure */
	unsigned long	dwDataType;			/* data type (=0x0001) */
	unsigned long	dwBitDepth;		/* bit depth of dither */
	unsigned long	dwBitCount;			/* bit depth of threshold */
	unsigned long	dwPixBytes;			/* bytes per pixel */
	unsigned long	dwWidth;			/* width of dither */
	unsigned long	dwHeight;			/* height of dither */
	unsigned char	byMatrix[4];		/* dither matrices */
} CAMatrixInfoData;

#if (defined(_MAC) || defined(_LINUX_BASE_DRV)) && defined(__LP64__)
typedef struct {
	unsigned long	dwSize;				/* size of this structure */
	unsigned long	dwDataType;			/* data type (=0x0001) */
	unsigned long	dwBitDepth;		/* bit depth of dither */
	unsigned long	dwBitCount;			/* bit depth of threshold */
	unsigned long	dwPixBytes;			/* bytes per pixel */
	unsigned long	dwWidth;			/* width of dither */
	unsigned long	dwHeight;			/* height of dither */
} CAMatrixInfoData_RemovebyMatrix;
#endif

typedef struct {
	CAMatrixInfoHeader	miHeader;		/* matrix information header */
	CAMatrixInfoData	miData[1];		/* matrix information */
} CAMatrixInfo;

// for HS
/* HS defines */
#define	kHS_EXCUTE_SRC_BUFFER_MAX	5
	
#define CAHS_RESULT_SUCCESS		0		/* 正常終了 */
#define CAHS_RESULT_ERROR		-1		/* 異常検出 */
#define CAHS_RESULT_NO_HS		1		/* HS処理を行わずに処理を継続 */
	
/* HS structs */

// for cahsExecuteLine
typedef struct {
	unsigned int	nNumLine;								// Excute line num
	unsigned char*	pSrcBuff[kHS_EXCUTE_SRC_BUFFER_MAX];	// Source Buffer(-2,-1,0,+1,+2 line)
	unsigned char*	pDstBuff;								// Dest Buffer
} CAHSExecuteTable;

// for cahsCheckParameter
typedef struct {
	unsigned int	nPixelWidth;	// Pixcel Width
	unsigned int	nPixelHeight;	// Pixcel Height
	unsigned short	wResoX;			// X-Resolution
	unsigned short	wResoY;			// Y-Resolution
	char			byteOrder;		// ByteOrder RGB/GBR/Gray
	unsigned int	nBytesPerLine;	//
	unsigned int	nROPCode;		// ROP Code
	unsigned int	nROPType;		// ROP Type
	unsigned int	nTrans;			// Trancs Type
} CAHSCheckParam;



/*------------------------------------------------
 *  API prototype declaration
 *------------------------------------------------*/

// CMS
CACGObj *cacmsInitialize(char*, short, short, CAObjCmsParam*, CAObjCmsParam*, CAObjCmsParam*, CALUTInfo*, short, char*);
CACGObj *cacmsInitialize2(char*, short, short, CAObjCmsParam*, CAObjCmsParam*, CAObjCmsParam*, CALUTInfo*, short, char*, short, void*);
CABool cacmsTerminate(CACGObj*);
CABool cacmsMatchLine(CACGObj*, CAByte*, CAByte*, int, int, short);
CABool cacmsMatchPixel(CACGObj*, CAByte*, int, short);
CABool cacmsNoMatchLine(CACGObj*, CAByte*, CAByte*, int, int, short);
CABool cacmsMatchLineForTruth(CACGObj*, CAByte*, CAByte*, int, short);
CABool cacmsMatchPixelForTruth(CACGObj*, CAByte*, short);

// CT
CACTObj *cactInitialize(char*, short, short, short, short, void*, CALUTInfo*, short, char*);
CACTObj *cactInitialize2(char*, short, short, short, short, short, short, short, void*, CALUTInfo*, short, char*);
void cactFreeCalib(short, void*);
void cactTerminate(CACTObj*);
CABool cactConvertLine(CACTObj*, CAByte*, CAByte*, int, int, int, int);
CABool cactGrayToKLine(CACTObj*, CAByte*, CAByte*, int, int);

// HT
CAHTObj *cahtInitialize(char*, short, short, short, short, int, int, short, char*);
CAHTObj *cahtInitialize2(char*, short, short, short, short, short, short, int, int, short, char*);
void cahtFuncInit(CAHTObj*, int, int);
void cahtTerminate(CAHTObj*);
void cahtConvertLine(CAHTObj*, CAByte*, CAByte*, int, int, int);
	void cahtConvertLineForMCD(CAHTObj*, CAByte*, CAByte*, int, int, int);
int	cahtGetDither(CAHTObj*, void*, int, int);

// TNL
CATNLObj *catnlInitialize(char*, short, short, short, short, short, short);
void catnlTerminate(CATNLObj*);
CABool catnlConvertRGBLine(CATNLObj*, CAByte*, CAByte*, int);
CABool catnlConvertARGBLine(CATNLObj*, CAByte*, CAByte*, int, CABool);
CABool catnlConvertRGBLineS2S(CATNLObj*, CAByte*, int);
CABool catnlConvertGrayLine(CATNLObj*, CAByte*, CAByte*, int);
CABool catnlConvertAGrayLine(CATNLObj*, CAByte*, CAByte*, int, CABool);
CABool catnlConvertDIBPlane(CATNLObj*, CAByte*, CAByte*, int, int);
CABool catnlConvertRGB(CATNLObj*, CAByte*);
CABool catnlConvertGray(CATNLObj*, CAByte*);

// HS
CAHSObj* cahsInitialize(char*, char, short, char*);
int cahsCheckParameter(CAHSObj*, CAHSCheckParam*);
CABool cahsTerminate(CAHSObj*);
int cahsExecuteLine(CAHSObj*, CAHSExecuteTable*);

#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif	/* _CMM_WRAPAPI_H */
