%define VERSION 4.90
%define RELEASE 1

%ifarch x86_64
%define	_machine_type "MACHINETYPE=x86_64"
%define	_cflags "CFLAGS=-m64 -march=x86-64"
%define	_arc _x86_64
%define _libdir /usr/lib64
%else
%ifarch aarch64
%define	_machine_type "MACHINETYPE=aarch64"
%define _cflags ""
%define	_arc _aarch64
%define _libdir /usr/lib64
%else
%ifarch mips64el
%define	_machine_type "MACHINETYPE=mips64el"
%define _cflags ""
%define	_arc _mips64
%define _libdir /usr/lib64
%else
%define	_machine_type "MACHINETYPE=i686"
%define	_cflags "CFLAGS=-m32 -march=i686"
%define	_arc _i686
%define _libdir /usr/lib
%endif
%endif
%endif

%define _prefix /usr
%define _bindir %{_prefix}/bin
%define _bjlibdir /usr/lib

%define CNCP_LIBS_COM libcncpmslld2 libcncpnet2 libcncpnet20 libcncpnet30

Summary: ScanGear MP Ver.%{VERSION} for Linux
Name: scangearmp2
Version: %{VERSION}
Release: %{RELEASE}
License: See the LICENSE*.txt file.
Vendor: CANON INC.
Group: Applications/Graphics
Source0: scangearmp2-source-%{version}-%{release}.tar.gz
BuildRoot: %{_tmppath}/%{name}-root
Requires: gtk2
BuildRequires: gtk2-devel


%description
ScanGear MP for Linux.
This ScanGear MP provides scanning functions for Canon Multifunction Inkjet Printer.


%prep
%setup -q -n scangearmp2-source-%{version}-%{release}


%build
#make


%install
# make install directory
mkdir -p ${RPM_BUILD_ROOT}%{_bindir}
mkdir -p ${RPM_BUILD_ROOT}%{_libdir}
mkdir -p ${RPM_BUILD_ROOT}%{_bjlibdir}/bjlib
mkdir -p ${RPM_BUILD_ROOT}/etc/udev/rules.d/
mkdir -p ${RPM_BUILD_ROOT}%{_datadir}/doc/scangearmp2-%{version}
mkdir -p ${RPM_BUILD_ROOT}%{_prefix}/share/locale/de/LC_MESSAGES
mkdir -p ${RPM_BUILD_ROOT}%{_prefix}/share/locale/fr/LC_MESSAGES
mkdir -p ${RPM_BUILD_ROOT}%{_prefix}/share/locale/ja/LC_MESSAGES
mkdir -p ${RPM_BUILD_ROOT}%{_prefix}/share/locale/zh/LC_MESSAGES
mkdir -p ${RPM_BUILD_ROOT}%{_prefix}/share/scangearmp2

# copy common libraries
install -c -m 755 com/libs_bin%{_arc}/*.so.* ${RPM_BUILD_ROOT}%{_libdir}
install -c -m 666 com/ini/canon_mfp2_net.ini ${RPM_BUILD_ROOT}%{_bjlibdir}/bjlib

# copy rules file
cd scangearmp2
	install -c -m 644 etc/*.rules ${RPM_BUILD_ROOT}/etc/udev/rules.d/
cd -

if [ %{nobuild} != '1' ]; then
	# make install
	cd scangearmp2
		./autogen.sh %{_machine_type} %{_cflags} --prefix=%{_prefix} --enable-libpath=%{_bjlibdir} LDFLAGS="-L`pwd`/../com/libs_bin%{_arc}"
		make clean
		make
		make install DESTDIR=${RPM_BUILD_ROOT} 
		# remove .la .a
		rm -f ${RPM_BUILD_ROOT}%{_libdir}/*.la ${RPM_BUILD_ROOT}%{_libdir}/*.a
	cd -
else
	install -c -m 755 com/libs_bin%{_arc}/scangearmp2 ${RPM_BUILD_ROOT}%{_bindir}
	install -c -m 644 com/libs_bin%{_arc}/de/LC_MESSAGES/scangearmp2.mo ${RPM_BUILD_ROOT}%{_prefix}/share/locale/de/LC_MESSAGES
	install -c -m 644 com/libs_bin%{_arc}/fr/LC_MESSAGES/scangearmp2.mo ${RPM_BUILD_ROOT}%{_prefix}/share/locale/fr/LC_MESSAGES
	install -c -m 644 com/libs_bin%{_arc}/ja/LC_MESSAGES/scangearmp2.mo ${RPM_BUILD_ROOT}%{_prefix}/share/locale/ja/LC_MESSAGES
	install -c -m 644 com/libs_bin%{_arc}/zh/LC_MESSAGES/scangearmp2.mo ${RPM_BUILD_ROOT}%{_prefix}/share/locale/zh/LC_MESSAGES
	install -c -m 644 scangearmp2/scangearmp2.glade ${RPM_BUILD_ROOT}%{_prefix}/share/scangearmp2
	install -c -m 644 scangearmp2/src/canon_mfp2.conf ${RPM_BUILD_ROOT}%{_bjlibdir}/bjlib
fi

%clean
rm -rf $RPM_BUILD_ROOT


%post
if [ -x /sbin/ldconfig ]; then
	/sbin/ldconfig
fi
#reload udev rules
if [ -x /sbin/udevadm ]; then
	/sbin/udevadm control --reload-rules 2> /dev/null
	/sbin/udevadm trigger --action=add --subsystem-match=usb 2> /dev/null
fi

%postun
# remove symbolic link (common libs)
for LIBS in %{CNCP_LIBS_COM}
do
	if [ -h %{_libdir}/${LIBS}.so ]; then
		rm -f %{_libdir}/${LIBS}.so
	fi	
done

# remove sgmp2_setting files
rm -f /var/tmp/canon_sgmp2_setting*.*

# remove directory
if [ "$1" = 0 ] ; then
	rmdir -p --ignore-fail-on-non-empty %{_prefix}/share/locale/*/LC_MESSAGES
	rmdir -p --ignore-fail-on-non-empty %{_prefix}/share/scangearmp2
	rmdir -p --ignore-fail-on-non-empty %{_bjlibdir}/bjlib
	rmdir -p --ignore-fail-on-non-empty %{_bindir}
fi

if [ -x /sbin/ldconfig ]; then
	/sbin/ldconfig
fi


%files
%defattr(-,root,root)
%{_libdir}/libcncpmslld2.so*
%{_libdir}/libcncpnet2.so*
%{_libdir}/libcncpnet20.so*
%{_libdir}/libcncpnet30.so*

%{_bindir}/scangearmp2
%{_bjlibdir}/bjlib/canon_mfp2.conf
%{_prefix}/share/locale/*/LC_MESSAGES/scangearmp2.mo
%{_prefix}/share/scangearmp2/*

/etc/udev/rules.d/*.rules

%doc doc/LICENSE-scangearmp-%{VERSION}EN.txt
%doc doc/LICENSE-scangearmp-%{VERSION}JP.txt
%doc doc/LICENSE-scangearmp-%{VERSION}FR.txt
%doc doc/LICENSE-scangearmp-%{VERSION}SC.txt
%doc doc/Readme_EN.txt
%doc doc/Readme_JP.txt
%doc doc/Readme_FR.txt
%doc doc/Readme_SC.txt


%attr(666,root,root) %{_bjlibdir}/bjlib/canon_mfp2_net.ini




%ChangeLog

