%define VERSION 6.20
%define RELEASE 1.01

%ifarch x86_64
%define	_machine_type "MACHINETYPE=x86_64"
%define	_cflags "CFLAGS=-m64 -march=x86-64"
%define	_libsarch libs64/intel
%else
%ifarch aarch64
%define	_machine_type "MACHINETYPE=aarch64"
%define _cflags "CFLAGS=-fsigned-char"
%define	_libsarch libs64/arm
%else
%ifarch mips64el
%define	_machine_type "MACHINETYPE=mips64el"
%define _cflags ""
%define	_libsarch libs64/mips
%else
%define	_machine_type "MACHINETYPE=i686"
%define	_cflags "CFLAGS=-m32 -march=i686"
%define	_libsarch libs32/intel
%endif
%endif
%endif
%define locallibs  /usr/lib

%define common_dir cnrdrvcups-common-%{VERSION}
%define driver_dir cnrdrvcups-lb-%{VERSION}
%define utility_dir cnrdrvcups-utility-%{VERSION}
%define b_lib_dir %{_builddir}/lib
%define b_include_dir %{_builddir}/include

%define debug_package %{nil}

#==== introduction ============================================================================================

Summary: Canon UFR II / LIPSLX Printer Driver for Linux v%{VERSION}
Name: cnrdrvcups-lb
Version: %{VERSION}
Release: %{RELEASE}
License: See the LICENSE*.txt file.
# Copyright: Copyright CANON INC. 2004
Vendor: CANON INC.
Group: Applications/Publishing
Source0: cnrdrvcups-lb-%{version}-%{release}.tar.xz
BuildRoot: %{_tmppath}/%{name}-root

%description 
Canon UFR II / LIPSLX Printer Driver for Linux. 
This UFR II / LIPSLX printer driver provides printing functions for Canon LBP/iR
printers operating under the CUPS (Common UNIX Printing System) environment.

%package -n cnrdrvcups-ufr2-uk
Summary: Canon UFR II Printer Driver for Linux v%{VERSION}
License: See the LICENSE*.txt file.
Vendor: CANON INC.
Group: Applications/Publishing
Requires: cups, gtk3, libjpeg-turbo, jbigkit-libs, libgcrypt, /usr/bin/lsb_release
Obsoletes: cnrcupsiradv715zk, cnrcupsiradv615zk, cnrcupsiradv525zk, cnrcupsiradv7153zk, cnrcupsiradv6153zk, cnrcupsiradv5253zk, cnrcupsiradv85053zk, cnrcupsiradv85853zk 
Obsoletes: cnrcupsiradv65753zk, cnrcupsiradv65553zk, cnrcupsiradvc35203zk, cnrcupsiradvc35253zk, cnrcupsiradvc75803zk,cnrcupsiradvc75653zk, cnrcupsiradvc2563zk, cnrcupsiradvc55353zk 
Obsoletes: cnrcupsiradvc55503zk, cnrcupsiradv45453zk, cnrcupsiradv45253zk, cnrcupsiradvc4753zk, cnrcupswg7000zk, cnrcupswg7000zzk, cnrcupslbp853czk, cnrcupslbp852czk, cnrcupsd1600zk
Obsoletes: cnrcupsiprc165zk, cnrcupsir1643izk, cnrcupsir1643pzk, cnrcupslbp323zk, cnrcupslbp621czk, cnrcupslbp622czk, cnrcupslbp663czk, cnrcupslbp664czk, cnrcupsmf440zk, cnrcupsmf540zk
Obsoletes: cnrcupsmf641czk, cnrcupsmf642czk, cnrcupsmf645czk, cnrcupsmf741czk, cnrcupsmf742czk, cnrcupsmf745czk, cnrcupsiprc710zk, cnrcupsir2625zk, cnrcupsir2635zk, cnrcupsiradv4725zk
Obsoletes: cnrcupsiradv4745zk, cnrcupsiradv6000zk, cnrcupsiradv6755zk, cnrcupsiradv6780zk, cnrcupsiradv8705zk, cnrcupsiradv8786zk, cnrcupsiradvc3720zk, cnrcupsiradvc3725zk
Obsoletes: cnrcupsiradvc5735zk, cnrcupsiradvc5750zk, cnrcupsiradvc7765zk, cnrcupsiradvc7780zk, cnrcupsirc3120lzk, cnrcupsirc3120zk, cnrcupsirc3125zk, cnrcupslbp222zk, cnrcupslbp223zk
Obsoletes: cnrcupslbp225zk, cnrcupslbp226zk, cnrcupslbp227zk, cnrcupslbp228zk, cnrcupsx1643pzk, cnrcupsiprc170zk, cnrcupsir2425zk, cnrcupsiradv527zk, cnrcupsiradv617zk
Obsoletes: cnrcupsiradv717zk, cnrcupsiradvc257zk, cnrcupsiradvc477zk, cnrcupslbp1127czk, cnrcupslbp1238zk, cnrcupsmf1127czk, cnrcupsmf1238zk, cnrcupsir1643i2zk, cnrcupsiradv6860zk
Obsoletes: cnrcupsiradvc3822zk, cnrcupsiradvc3826zk, cnrcupsiradvc3830zk, cnrcupsiradvc3835zk, cnrcupsiradvc568zk, cnrcupsiradvc5840zk, cnrcupsiradvc5860zk, cnrcupsirc1533izk
Obsoletes: cnrcupsirc1538izk, cnrcupsirc3130lzk, cnrcupsirc3222lzk, cnrcupsirc3222zk, cnrcupsirc3226zk, cnrcupslbp12382zk, cnrcupslbp1533czk, cnrcupslbp1538czk, cnrcupslbp233zk
Obsoletes: cnrcupslbp236zk, cnrcupslbp237zk, cnrcupslbp631czk, cnrcupslbp632czk, cnrcupslbp633czk, cnrcupslbp720czk, cnrcupslbp722czk, cnrcupsmf12382zk, cnrcupsmf1538czk
Obsoletes: cnrcupsmf1643izk, cnrcupsmf450zk, cnrcupsmf550zk, cnrcupsmf650czk, cnrcupsmf830czk, cnrcupsmf832czk
%description -n cnrdrvcups-ufr2-uk
Canon UFR II Printer Driver for Linux. 
This UFR II printer driver provides printing functions for Canon LBP/iR
printers operating under the CUPS (Common UNIX Printing System) environment.

%package -n cnrdrvcups-ufr2-us
Summary: Canon UFR II Printer Driver for Linux v%{VERSION}
License: See the LICENSE*.txt file.
Vendor: CANON INC.
Group: Applications/Publishing
Requires: cups, gtk3, libjpeg-turbo, jbigkit-libs, libgcrypt, zlib, /usr/bin/lsb_release
Obsoletes: cnrcupsiradv715zs, cnrcupsiradv615zs, cnrcupsiradv525zs, cnrcupsiradv7153zs, cnrcupsiradv6153zs, cnrcupsiradv5253zs, cnrcupsiradv85053zs, cnrcupsiradv85853zs 
Obsoletes: cnrcupsiradv65753zs, cnrcupsiradv65553zs, cnrcupsiradvc35253zs, cnrcupsiradvc75803zs, cnrcupsiradvc75653zs, cnrcupsiradvc2563zs, cnrcupsiradvc55353zs, cnrcupsiradvc55503zs 
Obsoletes: cnrcupsiradv45453zs, cnrcupsiradv45253zs, cnrcupsiradvc4753zs, cnrcupswg7000zs, cnrcupswg7000zzs, cnrcupsd1600zs, cnrcupsiprc165zs, cnrcupsir1643izs, cnrcupsir1643pzs
Obsoletes: cnrcupslbp323zs, cnrcupslbp622czs, cnrcupslbp664czs, cnrcupsmf440zs, cnrcupsmf540zs, cnrcupsmf641czs, cnrcupsmf642czs, cnrcupsmf741czs, cnrcupsmf745czs, cnrcupsiprc710zs
Obsoletes: cnrcupsiradv4725zs, cnrcupsiradv4745zs, cnrcupsiradv6000zs, cnrcupsiradv6755zs, cnrcupsiradv6780zs, cnrcupsiradv8705zs, cnrcupsiradv8786zs, cnrcupsiradvc3725zs
Obsoletes: cnrcupsiradvc5735zs, cnrcupsiradvc5750zs, cnrcupsiradvc7765zs, cnrcupsiradvc7780zs, cnrcupslbp223zs, cnrcupslbp226zs, cnrcupslbp227zs, cnrcupslbp228zs, cnrcupsiprc170zs
Obsoletes: cnrcupsiradv527zs, cnrcupsiradv617zs, cnrcupsiradv717zs, cnrcupsiradvc257zs, cnrcupsiradvc477zs, cnrcupslbp1127czs, cnrcupslbp1238zs, cnrcupsmf1127czs, cnrcupsmf1238zs
Obsoletes: cnrcupsir1643i2zs, cnrcupsiradv6860zs, cnrcupsiradvc3826zs, cnrcupsiradvc3830zs, cnrcupsiradvc3835zs, cnrcupsiradvc568zs, cnrcupsiradvc5840zs, cnrcupsiradvc5860zs
Obsoletes: cnrcupsirc3226zs, cnrcupslbp12382zs, cnrcupslbp1538czs, cnrcupslbp236zs, cnrcupslbp237zs, cnrcupslbp632czs, cnrcupslbp633czs, cnrcupsmf12382zs, cnrcupsmf1538czs
Obsoletes: cnrcupsmf1643izs, cnrcupsmf450zs, cnrcupsmf650czs
%description -n cnrdrvcups-ufr2-us
Canon UFR II Printer Driver for Linux. 
This UFR II printer driver provides printing functions for Canon LBP/iR
printers operating under the CUPS (Common UNIX Printing System) environment.

%package -n cnrdrvcups-lipslx
Summary: Canon LIPSLX Printer Driver for Linux v%{VERSION}
License: See the LICENSE*.txt file.
Vendor: CANON INC.
Group: Applications/Publishing
Requires: cups, gtk3, libjpeg-turbo, jbigkit-libs, libgcrypt, zlib, /usr/bin/lsb_release
Obsoletes: cnrcupsiradv85053zj, cnrcupsiradv85853zj, cnrcupsiradv65753zj, cnrcupsiradv65653zj, cnrcupsiradv65603zj, cnrcupsiradvc35203zj, cnrcupsiradvc75803zj, cnrcupsiradvc75653zj 
Obsoletes: cnrcupsiradvc3563zj, cnrcupsiradvc55353zj, cnrcupsiradvc55503zj, cnrcupsiradv45453zj, cnrcupsiradv45253zj, cnrcupswg7000zj, cnrcupswg7000zzj, cnrcupslbp853czj
Obsoletes: cnrcupslbp852czj, cnrcupslbp851czjcnrcupsiprc165zj, cnrcupslbp161zj, cnrcupslbp321zj, cnrcupslbp621czj, cnrcupslbp622czj, cnrcupslbp661czj, cnrcupslbp662czj
Obsoletes: cnrcupsmf440zj, cnrcupsmf540zj, cnrcupsmf642czj, cnrcupsmf741czj, cnrcupsmf745czj, cnrcupsiprc660zj, cnrcupsiradv4725zj, cnrcupsiradv4745zj, cnrcupsiradv6000zj
Obsoletes: cnrcupsiradv6765zj, cnrcupsiradv6780zj, cnrcupsiradv8705zj, cnrcupsiradv8786zj, cnrcupsiradvc3720zj, cnrcupsiradvc5735zj, cnrcupsiradvc5750zj, cnrcupsiradvc7765zj
Obsoletes: cnrcupsiradvc7780zj, cnrcupslbp221zj, cnrcupslbp224zj, cnrcupsmf260zj, cnrcupsmf7525zj, cnrcupsiprc170zj, cnrcupsiradvc357zj, cnrcupsiradv6860zj, cnrcupsiradvc3826zj
Obsoletes: cnrcupsiradvc3830zj, cnrcupsiradvc3835zj, cnrcupsiradvc5840zj, cnrcupsiradvc5860zj, cnrcupsirc3222zj,cnrcupslbp722czj, cnrcupslbp961czj, cnrcupsmf450zj, cnrcupsmf550zj
Obsoletes: cnrcupsmf650czj, cnrcupsmf832czj
%description -n cnrdrvcups-lipslx
Canon LIPSLX Printer Driver for Linux. 
This LIPSLX printer driver provides printing functions for Canon LBP/iR
printers operating under the CUPS (Common UNIX Printing System) environment.

#==== prep section ============================================================================================
%prep

%setup -q

if [ %{nobuild} != '1' ]; then
	##### common #####
	cd %{_builddir}/%{common_dir}
	cd buftool
	./autogen.sh %{_machine_type} %{_cflags} --prefix=%{_prefix} --libdir=%{_libdir} --enable-progpath=%{_bindir} --disable-shared --enable-static

	cd ../cngplp
	./autogen.sh %{_machine_type} %{_cflags} --prefix=%{_prefix} --libdir=%{locallibs} COMMON_SUFFIX=2

	cd ../backend
	./autogen.sh %{_machine_type} %{_cflags} --prefix=%{_prefix} --libdir=%{_libdir} MODULE_SUFFIX=ufr2

	cd ../rasterfilter
	./autogen.sh %{_machine_type} %{_cflags} --prefix=%{_prefix} --libdir=%{_libdir}

	cd ../cnjbig
	./autogen.sh %{_machine_type} %{_cflags} --prefix=%{_prefix}
	cd ..

	cd ..
	##### driver #####
	cd %{_builddir}/%{driver_dir}

	cd cpca
	./autogen.sh %{_machine_type} %{_cflags} --prefix=%{_prefix} --libdir=%{_libdir} --enable-progpath=%{_bindir}

	cd ../cngplp
	./autogen.sh %{_machine_type} %{_cflags} --prefix=%{_prefix} --libdir=%{_libdir}

	cd files
	./autogen.sh %{_machine_type} %{_cflags}
	cd ..

	cd ../pdftocpca
	./autogen.sh %{_machine_type} %{_cflags} --libdir=%{_libdir}
	cd ..

	cd ..


	##### utility #####
	cd ${RPM_BUILD_DIR}/%{utility_dir}
	cd ..
fi

#==== build section ============================================================================================
%build
if [ %{nobuild} != '1' ]; then
	cd ${RPM_BUILD_DIR}/%{common_dir}
	cd buftool
	make
	cp libbuftool.a %{b_lib_dir}/
	cp buftool.h %{b_include_dir}/
	cp buflist.h %{b_include_dir}/
	cd ..

	make 

	cd ..

	cd ${RPM_BUILD_DIR}/%{driver_dir}
	make 
	cd ..
fi

#==== install section ============================================================================================
%install

mkdir -pv ${RPM_BUILD_ROOT}%{_libdir}
mkdir -pv ${RPM_BUILD_ROOT}%{_bindir}
mkdir -pv ${RPM_BUILD_ROOT}%{_prefix}/bin
mkdir -pv ${RPM_BUILD_ROOT}%{_libdir}
mkdir -pv ${RPM_BUILD_ROOT}%{locallibs}/cups/filter
mkdir -pv ${RPM_BUILD_ROOT}%{locallibs}/cups/backend/
mkdir -pv ${RPM_BUILD_ROOT}%{_includedir}
mkdir -pv ${RPM_BUILD_ROOT}%{_prefix}/share/locale/ja/LC_MESSAGES
mkdir -pv ${RPM_BUILD_ROOT}%{_prefix}/share/cups/usb
mkdir -pv ${RPM_BUILD_ROOT}%{_prefix}/share/cups/model
mkdir -pv ${RPM_BUILD_ROOT}%{_prefix}/share/caepcm/ufr2
mkdir -pv ${RPM_BUILD_ROOT}%{_prefix}/share/cnpkbidir
mkdir -pv ${RPM_BUILD_ROOT}%{_prefix}/share/ufr2filterr
# cngplp
mkdir -pv ${RPM_BUILD_ROOT}%{_prefix}/share/cngplp2/
mkdir -pv ${RPM_BUILD_ROOT}%{locallibs}
#utility
mkdir -pv ${RPM_BUILD_ROOT}%{_prefix}/share/cnsetuputil2
mkdir -pv ${RPM_BUILD_ROOT}%{_prefix}/share/locale/ja/LC_MESSAGES
mkdir -pv ${RPM_BUILD_ROOT}%{_prefix}/share/locale/de/LC_MESSAGES
mkdir -pv ${RPM_BUILD_ROOT}%{_prefix}/share/locale/es/LC_MESSAGES
mkdir -pv ${RPM_BUILD_ROOT}%{_prefix}/share/locale/fr/LC_MESSAGES
mkdir -pv ${RPM_BUILD_ROOT}%{_prefix}/share/locale/it/LC_MESSAGES
mkdir -pv ${RPM_BUILD_ROOT}%{_prefix}/share/locale/zh_CN/LC_MESSAGES
mkdir -pv ${RPM_BUILD_ROOT}%{_prefix}/share/locale/ko/LC_MESSAGES
mkdir -pv ${RPM_BUILD_ROOT}%{_prefix}/share/locale/zh_TW/LC_MESSAGES

#### common ####
if [ %{nobuild} != '1' ]; then
	cd ${RPM_BUILD_DIR}/%{common_dir}
	make install DESTDIR=${RPM_BUILD_ROOT} COMMON_SUFFIX=2

	install -c -m 644 Rule/canon-laser-printer.usb-quirks	${RPM_BUILD_ROOT}%{_prefix}/share/cups/usb/canon-laser-printer_ufr2.usb-quirks
	cd -
else
	mkdir -pv -m 777 ${RPM_BUILD_ROOT}/etc/cngplp2/account
	mkdir -pv -m 777 ${RPM_BUILD_ROOT}/etc/cngplp2/options

	cd %{b_lib_dir}
	install -c -m 755 %{_libsarch}/rastertoufr2	${RPM_BUILD_ROOT}%{locallibs}/cups/filter
	install -c -m 755 %{_libsarch}/cnjatool2	${RPM_BUILD_ROOT}%{_bindir}
	install -c -m 755 %{_libsarch}/cngplp2		${RPM_BUILD_ROOT}%{_bindir}
	install -c -m 755 %{_libsarch}/cnusbufr2	${RPM_BUILD_ROOT}%{locallibs}/cups/backend
	install -c -m 755 %{_libsarch}/cnjbigufr2	${RPM_BUILD_ROOT}%{_bindir}
	cd -

	cd ${RPM_BUILD_DIR}/%{common_dir}
	install -c -m 644 Rule/canon-laser-printer.usb-quirks	${RPM_BUILD_ROOT}%{_prefix}/share/cups/usb/canon-laser-printer_ufr2.usb-quirks
	cd -
fi

cd %{b_lib_dir}
install -c -m 755 %{_libsarch}/libcaiowrapufr2.so.1.0.0		${RPM_BUILD_ROOT}%{_libdir}
install -c -m 755 %{_libsarch}/libcaepcmufr2.so.1.0			${RPM_BUILD_ROOT}%{_libdir}
install -c -m 755 %{_libsarch}/libColorGearCufr2.so.2.0.0    ${RPM_BUILD_ROOT}%{_libdir}
install -c -m 644 data/ufr2/*.ICC	${RPM_BUILD_ROOT}%{_prefix}/share/caepcm/ufr2
install -c -m 644 data/ufr2/*.icc	${RPM_BUILD_ROOT}%{_prefix}/share/caepcm/ufr2
install -c -m 644 data/ufr2/*.PRF	${RPM_BUILD_ROOT}%{_prefix}/share/caepcm/ufr2
install -c -m 755 %{_libsarch}/libcanon_slimufr2.so.1.0.0		${RPM_BUILD_ROOT}%{_libdir}
cd -

cd ${RPM_BUILD_ROOT}%{_libdir}
ln -sf libcaepcmufr2.so.1.0			libcaepcmufr2.so.1
ln -sf libcaepcmufr2.so.1.0			libcaepcmufr2.so
ln -sf libcaiowrapufr2.so.1.0.0		libcaiowrapufr2.so.1
ln -sf libcaiowrapufr2.so.1.0.0		libcaiowrapufr2.so
ln -sf libcanon_slimufr2.so.1.0.0		libcanon_slimufr2.so.1
ln -sf libcanon_slimufr2.so.1.0.0		libcanon_slimufr2.so
ln -sf libColorGearCufr2.so.2.0.0   libColorGearCufr2.so.2
ln -sf libColorGearCufr2.so.2.0.0   libColorGearCufr2.so
cd -

#### driver ####
if [ %{nobuild} != '1' ]; then
	cd ${RPM_BUILD_DIR}/%{driver_dir}
	make install DESTDIR=${RPM_BUILD_ROOT}

	install -c -m 644 ppd/CN*.ppd	${RPM_BUILD_ROOT}%{_prefix}/share/cups/model
	cd -
else
	cd ${RPM_BUILD_DIR}/%{common_dir}
	install -c -m 644 cngplp/src/cngplp.ui							        ${RPM_BUILD_ROOT}%{_prefix}/share/cngplp2
	cd -

	cd ${RPM_BUILD_DIR}/%{driver_dir}
	install -c -m 644 cngplp/files/cngplp_ufr2.ui						    ${RPM_BUILD_ROOT}%{_prefix}/share/cngplp2
	install -c -m 644 cngplp/files/func_config_ufr2.xml				        ${RPM_BUILD_ROOT}%{_prefix}/share/cngplp2
	install -c -m 644 cngplp/files/*.res								    ${RPM_BUILD_ROOT}%{_prefix}/share/cngplp2
	cd -

	cd %{b_lib_dir}
	install -c -m 755 %{_libsarch}/libuictlufr2r.so.1.0.0					${RPM_BUILD_ROOT}%{_libdir}
	install -c -m 755 %{_libsarch}/pdftocpca								${RPM_BUILD_ROOT}%{locallibs}/cups/filter
	install -c -m 644 %{_libsarch}/ja/LC_MESSAGES/cngplp2.mo				${RPM_BUILD_ROOT}%{_prefix}/share/locale/ja/LC_MESSAGES
	install -c -m 644 %{_libsarch}/de/LC_MESSAGES/cngplp2.mo				${RPM_BUILD_ROOT}%{_prefix}/share/locale/de/LC_MESSAGES
	install -c -m 644 %{_libsarch}/es/LC_MESSAGES/cngplp2.mo				${RPM_BUILD_ROOT}%{_prefix}/share/locale/es/LC_MESSAGES
	install -c -m 644 %{_libsarch}/fr/LC_MESSAGES/cngplp2.mo				${RPM_BUILD_ROOT}%{_prefix}/share/locale/fr/LC_MESSAGES
	install -c -m 644 %{_libsarch}/it/LC_MESSAGES/cngplp2.mo				${RPM_BUILD_ROOT}%{_prefix}/share/locale/it/LC_MESSAGES
	install -c -m 644 %{_libsarch}/zh_CN/LC_MESSAGES/cngplp2.mo				${RPM_BUILD_ROOT}%{_prefix}/share/locale/zh_CN/LC_MESSAGES
	install -c -m 644 %{_libsarch}/ko/LC_MESSAGES/cngplp2.mo				${RPM_BUILD_ROOT}%{_prefix}/share/locale/ko/LC_MESSAGES
	install -c -m 644 %{_libsarch}/zh_TW/LC_MESSAGES/cngplp2.mo				${RPM_BUILD_ROOT}%{_prefix}/share/locale/zh_TW/LC_MESSAGES
	install -c -m 644 %{_libsarch}/ja/LC_MESSAGES/libuictlufr2r.1.0.mo		${RPM_BUILD_ROOT}%{_prefix}/share/locale/ja/LC_MESSAGES
	install -c -m 644 %{_libsarch}/de/LC_MESSAGES/libuictlufr2r.1.0.mo		${RPM_BUILD_ROOT}%{_prefix}/share/locale/de/LC_MESSAGES
	install -c -m 644 %{_libsarch}/es/LC_MESSAGES/libuictlufr2r.1.0.mo		${RPM_BUILD_ROOT}%{_prefix}/share/locale/es/LC_MESSAGES
	install -c -m 644 %{_libsarch}/fr/LC_MESSAGES/libuictlufr2r.1.0.mo		${RPM_BUILD_ROOT}%{_prefix}/share/locale/fr/LC_MESSAGES
	install -c -m 644 %{_libsarch}/it/LC_MESSAGES/libuictlufr2r.1.0.mo		${RPM_BUILD_ROOT}%{_prefix}/share/locale/it/LC_MESSAGES
	install -c -m 644 %{_libsarch}/zh_CN/LC_MESSAGES/libuictlufr2r.1.0.mo	${RPM_BUILD_ROOT}%{_prefix}/share/locale/zh_CN/LC_MESSAGES
	install -c -m 644 %{_libsarch}/ko/LC_MESSAGES/libuictlufr2r.1.0.mo		${RPM_BUILD_ROOT}%{_prefix}/share/locale/ko/LC_MESSAGES
	install -c -m 644 %{_libsarch}/zh_TW/LC_MESSAGES/libuictlufr2r.1.0.mo	${RPM_BUILD_ROOT}%{_prefix}/share/locale/zh_TW/LC_MESSAGES
	cd -

	cd ${RPM_BUILD_DIR}/%{driver_dir}
	install -c -m 644 ppd/CN*.ppd	${RPM_BUILD_ROOT}%{_prefix}/share/cups/model
	cd -
fi

cd %{b_lib_dir}
install -c -m 4755 %{_libsarch}/cnpkmoduleufr2r 	${RPM_BUILD_ROOT}%{_bindir}
install -c -m  755 %{_libsarch}/cnpdfdrv 			${RPM_BUILD_ROOT}%{_bindir}
install -c -m 755 %{_libsarch}/libcanonufr2r.so.1.0.0  ${RPM_BUILD_ROOT}%{_libdir}
install -c -m 755 %{_libsarch}/libufr2filterr.so.1.0.0   ${RPM_BUILD_ROOT}%{_libdir}
install -c -m 755 %{_libsarch}/cnpkbidir   ${RPM_BUILD_ROOT}%{_bindir}
install -c -m 755 %{_libsarch}/libcaiocnpkbidir.so.1.0.0   ${RPM_BUILD_ROOT}%{_libdir}
install -c -m 755 %{_libsarch}/cnrsdrvufr2 	${RPM_BUILD_ROOT}%{_bindir}
install -c -m 644 data/ufr2/CnLB*	${RPM_BUILD_ROOT}%{_prefix}/share/caepcm/ufr2
install -c -m 644 %{_libsarch}/cnpkbidir_info*	${RPM_BUILD_ROOT}%{_prefix}/share/cnpkbidir
install -c -m 644 %{_libsarch}/ThLB*	${RPM_BUILD_ROOT}%{_prefix}/share/ufr2filterr
install -c -m 755 %{_libsarch}/libcnlbcmr.so.1.0			${RPM_BUILD_ROOT}%{_libdir}
cd -

cd ${RPM_BUILD_ROOT}%{_libdir}
ln -sf libcanonufr2r.so.1.0.0 libcanonufr2r.so
ln -sf libcanonufr2r.so.1.0.0 libcanonufr2r.so.1
ln -sf libufr2filterr.so.1.0.0 libufr2filterr.so
ln -sf libufr2filterr.so.1.0.0 libufr2filterr.so.1
ln -sf libcaiocnpkbidir.so.1.0.0 libcaiocnpkbidir.so
ln -sf libcaiocnpkbidir.so.1.0.0 libcaiocnpkbidir.so.1
ln -sf libcnlbcmr.so.1.0			libcnlbcmr.so.1
ln -sf libcnlbcmr.so.1.0			libcnlbcmr.so
ln -sf libuictlufr2r.so.1.0.0	libuictlufr2r.so.1
ln -sf libuictlufr2r.so.1.0.0	libuictlufr2r.so
cd -

#### utility ####
cd ${RPM_BUILD_DIR}/%{utility_dir}
install -c -m 644 data/cnsetuputil.ui	${RPM_BUILD_ROOT}%{_prefix}/share/cnsetuputil2
cd %{b_lib_dir}
install -c -m 755 %{_libsarch}/cnsetuputil2	${RPM_BUILD_ROOT}%{_prefix}/bin
install -c -m 644 %{_libsarch}/ja/LC_MESSAGES/cnsetuputil2.mo       ${RPM_BUILD_ROOT}%{_prefix}/share/locale/ja/LC_MESSAGES
install -c -m 644 %{_libsarch}/de/LC_MESSAGES/cnsetuputil2.mo       ${RPM_BUILD_ROOT}%{_prefix}/share/locale/de/LC_MESSAGES
install -c -m 644 %{_libsarch}/es/LC_MESSAGES/cnsetuputil2.mo       ${RPM_BUILD_ROOT}%{_prefix}/share/locale/es/LC_MESSAGES
install -c -m 644 %{_libsarch}/fr/LC_MESSAGES/cnsetuputil2.mo       ${RPM_BUILD_ROOT}%{_prefix}/share/locale/fr/LC_MESSAGES
install -c -m 644 %{_libsarch}/it/LC_MESSAGES/cnsetuputil2.mo       ${RPM_BUILD_ROOT}%{_prefix}/share/locale/it/LC_MESSAGES
install -c -m 644 %{_libsarch}/zh_CN/LC_MESSAGES/cnsetuputil2.mo    ${RPM_BUILD_ROOT}%{_prefix}/share/locale/zh_CN/LC_MESSAGES
install -c -m 644 %{_libsarch}/ko/LC_MESSAGES/cnsetuputil2.mo       ${RPM_BUILD_ROOT}%{_prefix}/share/locale/ko/LC_MESSAGES
install -c -m 644 %{_libsarch}/zh_TW/LC_MESSAGES/cnsetuputil2.mo    ${RPM_BUILD_ROOT}%{_prefix}/share/locale/zh_TW/LC_MESSAGES
cd -

#==== clean section ============================================================================================
%clean
rm -rf $RPM_BUILD_ROOT

%post -n cnrdrvcups-ufr2-uk
if [ -x /sbin/ldconfig ]; then
	/sbin/ldconfig
fi
if [ -f /etc/init.d/cups ]
then
	/etc/init.d/cups restart
elif [ -f /etc/init.d/cupsys ]
then
	/etc/init.d/cupsys restart
else
	service cups restart
fi
if [ -z "$LANG" ]
then
	export LANG=`localectl | grep -Eo "LANG=.*" | awk -F '=' '{print $2}'`
fi
export DISPLAY=:0
user=`users | awk '{print $1}'`
runuser -u $user xhost +SI:localuser:root
cnsetuputil2

%postun -n cnrdrvcups-ufr2-uk
if [ $1 = 0 ]; then
	if [ 1 -eq $(find %{_prefix}/share/cnpkbidir/ -maxdepth 0 -empty | wc -l) ]; then
		rm -rf %{_prefix}/share/cnpkbidir/
	fi
	if [ 1 -eq $(find %{_prefix}/share/ufr2filterr/ -maxdepth 0 -empty | wc -l) ]; then
		rm -rf %{_prefix}/share/ufr2filterr/
	fi
fi
if [ "$1" = 0 ] ; then
	cd /etc
	rm -rf cngplp2
	rm -rf %{_prefix}/share/cngplp2/
	rm -rf %{_prefix}/share/caepcm/ufr2/
fi
if [ -x /sbin/ldconfig ]; then
	/sbin/ldconfig
fi

%post -n cnrdrvcups-ufr2-us
if [ -x /sbin/ldconfig ]; then
	/sbin/ldconfig
fi
if [ -f /etc/init.d/cups ]
then
	/etc/init.d/cups restart
elif [ -f /etc/init.d/cupsys ]
then
	/etc/init.d/cupsys restart
else
	service cups restart
fi
if [ -z "$LANG" ]
then
	export LANG=`localectl | grep -Eo "LANG=.*" | awk -F '=' '{print $2}'`
fi
export DISPLAY=:0
user=`users | awk '{print $1}'`
runuser -u $user xhost +SI:localuser:root
cnsetuputil2

%postun -n cnrdrvcups-ufr2-us
if [ $1 = 0 ]; then
	if [ 1 -eq $(find %{_prefix}/share/cnpkbidir/ -maxdepth 0 -empty | wc -l) ]; then
		rm -rf %{_prefix}/share/cnpkbidir/
	fi
	if [ 1 -eq $(find %{_prefix}/share/ufr2filterr/ -maxdepth 0 -empty | wc -l) ]; then
		rm -rf %{_prefix}/share/ufr2filterr/
	fi
fi
if [ "$1" = 0 ] ; then
	cd /etc
	rm -rf cngplp2
	rm -rf %{_prefix}/share/cngplp2/
	rm -rf %{_prefix}/share/caepcm/ufr2/
fi
if [ -x /sbin/ldconfig ]; then
	/sbin/ldconfig
fi

%post -n cnrdrvcups-lipslx
if [ -x /sbin/ldconfig ]; then
	/sbin/ldconfig
fi
if [ -f /etc/init.d/cups ]
then
	/etc/init.d/cups restart
elif [ -f /etc/init.d/cupsys ]
then
	/etc/init.d/cupsys restart
else
	service cups restart
fi
if [ -z "$LANG" ]
then
	export LANG=`localectl | grep -Eo "LANG=.*" | awk -F '=' '{print $2}'`
fi
export DISPLAY=:0
user=`users | awk '{print $1}'`
runuser -u $user xhost +SI:localuser:root
cnsetuputil2

%postun -n cnrdrvcups-lipslx
if [ $1 = 0 ]; then
	if [ 1 -eq $(find %{_prefix}/share/cnpkbidir/ -maxdepth 0 -empty | wc -l) ]; then
		rm -rf %{_prefix}/share/cnpkbidir/
	fi
	if [ 1 -eq $(find %{_prefix}/share/ufr2filterr/ -maxdepth 0 -empty | wc -l) ]; then
		rm -rf %{_prefix}/share/ufr2filterr/
	fi
fi
if [ "$1" = 0 ] ; then
	cd /etc
	rm -rf cngplp2
	rm -rf %{_prefix}/share/cngplp2/
	rm -rf %{_prefix}/share/caepcm/ufr2/
fi
if [ -x /sbin/ldconfig ]; then
	/sbin/ldconfig
fi

#==== files section ============================================================================================
#==== ufr2 uk ====
%files -n cnrdrvcups-ufr2-uk
%defattr(-,root,root)

%{_prefix}/share/locale/ja/LC_MESSAGES/cngplp2.mo
%{_prefix}/share/locale/de/LC_MESSAGES/cngplp2.mo
%{_prefix}/share/locale/es/LC_MESSAGES/cngplp2.mo
%{_prefix}/share/locale/fr/LC_MESSAGES/cngplp2.mo
%{_prefix}/share/locale/it/LC_MESSAGES/cngplp2.mo
%{_prefix}/share/locale/zh_CN/LC_MESSAGES/cngplp2.mo
%{_prefix}/share/locale/ko/LC_MESSAGES/cngplp2.mo
%{_prefix}/share/locale/zh_TW/LC_MESSAGES/cngplp2.mo
# cngplp
%{_prefix}/share/cngplp2/cngplp.ui
#
%{_prefix}/bin/cngplp2
%{_prefix}/bin/cnjatool2
%{locallibs}/cups/backend/cnusbufr2
%{_sysconfdir}/cngplp2/account
%{_sysconfdir}/cngplp2/options

%{_libdir}/libcaiowrapufr2.so*

%{_libdir}/libcaepcmufr2.so*
%{_libdir}/libcanon_slimufr2.so*

%{_prefix}/share/caepcm/ufr2/C*
%{_prefix}/share/cups/usb/canon-laser-printer_ufr2.usb-quirks
%{_libdir}/libColorGearCufr2.so*

%{_libdir}/libcnlbcmr.so*
%{_libdir}/libcanonufr2r.*
%{_libdir}/libufr2filterr.*
%{_libdir}/libcaiocnpkbidir.*
%{_bindir}/cnpkbidir
%{_bindir}/cnpkmoduleufr2r

%{locallibs}/cups/filter/rastertoufr2
%{locallibs}/cups/filter/pdftocpca
%{_bindir}/cnrsdrvufr2
%{_bindir}/cnjbigufr2
%{_bindir}/cnpdfdrv

%{_prefix}/share/cups/model/CNRCUPS*ZK.ppd
%{_prefix}/share/cnpkbidir/cnpkbidi*
%{_prefix}/share/ufr2filterr/ThLB*
# cngplp
%{_libdir}/libuictlufr2r.*
%{_prefix}/share/cngplp2/cngplp_ufr2.ui
%{_prefix}/share/cngplp2/CN*ZK.res
%{_prefix}/share/cngplp2/common_ufr2.res
%{_prefix}/share/cngplp2/func_config_ufr2.xml
%{_prefix}/share/locale/ja/LC_MESSAGES/libuictlufr2r*.mo
%{_prefix}/share/locale/fr/LC_MESSAGES/libuictlufr2r*.mo
%{_prefix}/share/locale/it/LC_MESSAGES/libuictlufr2r*.mo
%{_prefix}/share/locale/de/LC_MESSAGES/libuictlufr2r*.mo
%{_prefix}/share/locale/es/LC_MESSAGES/libuictlufr2r*.mo
%{_prefix}/share/locale/zh_CN/LC_MESSAGES/libuictlufr2r*.mo
%{_prefix}/share/locale/ko/LC_MESSAGES/libuictlufr2r*.mo
%{_prefix}/share/locale/zh_TW/LC_MESSAGES/libuictlufr2r*.mo

%{_prefix}/share/cnsetuputil2/cnsetuputil.ui
%{_prefix}/share/locale/ja/LC_MESSAGES/cnsetuputil2.mo
%{_prefix}/share/locale/de/LC_MESSAGES/cnsetuputil2.mo
%{_prefix}/share/locale/es/LC_MESSAGES/cnsetuputil2.mo
%{_prefix}/share/locale/fr/LC_MESSAGES/cnsetuputil2.mo
%{_prefix}/share/locale/it/LC_MESSAGES/cnsetuputil2.mo
%{_prefix}/share/locale/zh_CN/LC_MESSAGES/cnsetuputil2.mo
%{_prefix}/share/locale/ko/LC_MESSAGES/cnsetuputil2.mo
%{_prefix}/share/locale/zh_TW/LC_MESSAGES/cnsetuputil2.mo
%{_prefix}/bin/cnsetuputil2

%exclude %{_libdir}/libColorGearC.so*

#==== ufr2 us ====
%files -n cnrdrvcups-ufr2-us
%defattr(-,root,root)

%{_prefix}/share/locale/ja/LC_MESSAGES/cngplp2.mo
%{_prefix}/share/locale/de/LC_MESSAGES/cngplp2.mo
%{_prefix}/share/locale/es/LC_MESSAGES/cngplp2.mo
%{_prefix}/share/locale/fr/LC_MESSAGES/cngplp2.mo
%{_prefix}/share/locale/it/LC_MESSAGES/cngplp2.mo
%{_prefix}/share/locale/zh_CN/LC_MESSAGES/cngplp2.mo
%{_prefix}/share/locale/ko/LC_MESSAGES/cngplp2.mo
%{_prefix}/share/locale/zh_TW/LC_MESSAGES/cngplp2.mo
# cngplp
%{_prefix}/share/cngplp2/cngplp.ui
#
%{_prefix}/bin/cngplp2
%{_prefix}/bin/cnjatool2
%{locallibs}/cups/backend/cnusbufr2
%{_sysconfdir}/cngplp2/account
%{_sysconfdir}/cngplp2/options

%{_libdir}/libcaiowrapufr2.so*

%{_libdir}/libcaepcmufr2.so*
%{_libdir}/libcanon_slimufr2.so*

%{_prefix}/share/caepcm/ufr2/C*
%{_prefix}/share/cups/usb/canon-laser-printer_ufr2.usb-quirks
%{_libdir}/libColorGearCufr2.so*

%{_libdir}/libcnlbcmr.so*
%{_libdir}/libcanonufr2r.*
%{_libdir}/libufr2filterr.*
%{_libdir}/libcaiocnpkbidir.*
%{_bindir}/cnpkbidir
%{_bindir}/cnpkmoduleufr2r

%{locallibs}/cups/filter/rastertoufr2
%{locallibs}/cups/filter/pdftocpca
%{_bindir}/cnrsdrvufr2
%{_bindir}/cnjbigufr2
%{_bindir}/cnpdfdrv

%{_prefix}/share/cups/model/CNRCUPS*ZS.ppd
%{_prefix}/share/cnpkbidir/cnpkbidi*
%{_prefix}/share/ufr2filterr/ThLB*
# cngplp
%{_libdir}/libuictlufr2r.*
%{_prefix}/share/cngplp2/cngplp_ufr2.ui
%{_prefix}/share/cngplp2/CN*ZS.res
%{_prefix}/share/cngplp2/common_ufr2.res
%{_prefix}/share/cngplp2/func_config_ufr2.xml
%{_prefix}/share/locale/ja/LC_MESSAGES/libuictlufr2r*.mo
%{_prefix}/share/locale/fr/LC_MESSAGES/libuictlufr2r*.mo
%{_prefix}/share/locale/it/LC_MESSAGES/libuictlufr2r*.mo
%{_prefix}/share/locale/de/LC_MESSAGES/libuictlufr2r*.mo
%{_prefix}/share/locale/es/LC_MESSAGES/libuictlufr2r*.mo
%{_prefix}/share/locale/zh_CN/LC_MESSAGES/libuictlufr2r*.mo
%{_prefix}/share/locale/ko/LC_MESSAGES/libuictlufr2r*.mo
%{_prefix}/share/locale/zh_TW/LC_MESSAGES/libuictlufr2r*.mo

%{_prefix}/share/cnsetuputil2/cnsetuputil.ui
%{_prefix}/share/locale/ja/LC_MESSAGES/cnsetuputil2.mo
%{_prefix}/share/locale/de/LC_MESSAGES/cnsetuputil2.mo
%{_prefix}/share/locale/es/LC_MESSAGES/cnsetuputil2.mo
%{_prefix}/share/locale/fr/LC_MESSAGES/cnsetuputil2.mo
%{_prefix}/share/locale/it/LC_MESSAGES/cnsetuputil2.mo
%{_prefix}/share/locale/zh_CN/LC_MESSAGES/cnsetuputil2.mo
%{_prefix}/share/locale/ko/LC_MESSAGES/cnsetuputil2.mo
%{_prefix}/share/locale/zh_TW/LC_MESSAGES/cnsetuputil2.mo
%{_prefix}/bin/cnsetuputil2

%exclude %{_libdir}/libColorGearC.so*

#==== lipslx ====
%files -n cnrdrvcups-lipslx

%{_prefix}/share/locale/ja/LC_MESSAGES/cngplp2.mo
%{_prefix}/share/locale/de/LC_MESSAGES/cngplp2.mo
%{_prefix}/share/locale/es/LC_MESSAGES/cngplp2.mo
%{_prefix}/share/locale/fr/LC_MESSAGES/cngplp2.mo
%{_prefix}/share/locale/it/LC_MESSAGES/cngplp2.mo
%{_prefix}/share/locale/zh_CN/LC_MESSAGES/cngplp2.mo
%{_prefix}/share/locale/ko/LC_MESSAGES/cngplp2.mo
%{_prefix}/share/locale/zh_TW/LC_MESSAGES/cngplp2.mo
# cngplp
%{_prefix}/share/cngplp2/cngplp.ui
#
%{_prefix}/bin/cngplp2
%{_prefix}/bin/cnjatool2
%{locallibs}/cups/backend/cnusbufr2
%{_sysconfdir}/cngplp2/account
%{_sysconfdir}/cngplp2/options

%{_libdir}/libcaiowrapufr2.so*

%{_libdir}/libcaepcmufr2.so*
%{_libdir}/libcanon_slimufr2.so*

%{_prefix}/share/caepcm/ufr2/C*
%{_prefix}/share/cups/usb/canon-laser-printer_ufr2.usb-quirks
%{_libdir}/libColorGearCufr2.so*

%defattr(-,root,root)
%{_libdir}/libcnlbcmr.so*
%{_libdir}/libcanonufr2r.*
%{_libdir}/libufr2filterr.*
%{_libdir}/libcaiocnpkbidir.*
%{_bindir}/cnpkbidir
%{_bindir}/cnpkmoduleufr2r

%{locallibs}/cups/filter/rastertoufr2
%{locallibs}/cups/filter/pdftocpca
%{_bindir}/cnrsdrvufr2
%{_bindir}/cnjbigufr2
%{_bindir}/cnpdfdrv

%{_prefix}/share/cups/model/CNRCUPS*ZJ.ppd
%{_prefix}/share/cnpkbidir/cnpkbidi*
%{_prefix}/share/ufr2filterr/ThLB*
# cngplp
%{_libdir}/libuictlufr2r.*
%{_prefix}/share/cngplp2/cngplp_ufr2.ui
%{_prefix}/share/cngplp2/CN*ZJ.res
%{_prefix}/share/cngplp2/common_ufr2.res
%{_prefix}/share/cngplp2/func_config_ufr2.xml
%{_prefix}/share/locale/ja/LC_MESSAGES/libuictlufr2r*.mo
%{_prefix}/share/locale/fr/LC_MESSAGES/libuictlufr2r*.mo
%{_prefix}/share/locale/it/LC_MESSAGES/libuictlufr2r*.mo
%{_prefix}/share/locale/de/LC_MESSAGES/libuictlufr2r*.mo
%{_prefix}/share/locale/es/LC_MESSAGES/libuictlufr2r*.mo
%{_prefix}/share/locale/zh_CN/LC_MESSAGES/libuictlufr2r*.mo
%{_prefix}/share/locale/ko/LC_MESSAGES/libuictlufr2r*.mo
%{_prefix}/share/locale/zh_TW/LC_MESSAGES/libuictlufr2r*.mo

%{_prefix}/share/cnsetuputil2/cnsetuputil.ui
%{_prefix}/share/locale/ja/LC_MESSAGES/cnsetuputil2.mo
%{_prefix}/share/locale/de/LC_MESSAGES/cnsetuputil2.mo
%{_prefix}/share/locale/es/LC_MESSAGES/cnsetuputil2.mo
%{_prefix}/share/locale/fr/LC_MESSAGES/cnsetuputil2.mo
%{_prefix}/share/locale/it/LC_MESSAGES/cnsetuputil2.mo
%{_prefix}/share/locale/zh_CN/LC_MESSAGES/cnsetuputil2.mo
%{_prefix}/share/locale/ko/LC_MESSAGES/cnsetuputil2.mo
%{_prefix}/share/locale/zh_TW/LC_MESSAGES/cnsetuputil2.mo
%{_prefix}/bin/cnsetuputil2

%exclude %{_libdir}/libColorGearC.so*
